/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.errors;

import com.clerk.backend_api.models.errors.VerifyM2MTokenErrors;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;

public class VerifyM2MTokenResponseBody
extends RuntimeException {
    @JsonProperty(value="errors")
    private List<VerifyM2MTokenErrors> errors;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="RawResponse")
    private Optional<? extends HttpResponse<InputStream>> rawResponse;

    @JsonCreator
    public VerifyM2MTokenResponseBody(@JsonProperty(value="errors") List<VerifyM2MTokenErrors> errors, @JsonProperty(value="RawResponse") Optional<? extends HttpResponse<InputStream>> rawResponse) {
        super("API error occurred");
        Utils.checkNotNull(errors, "errors");
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.errors = errors;
        this.rawResponse = rawResponse;
    }

    public VerifyM2MTokenResponseBody(List<VerifyM2MTokenErrors> errors) {
        this(errors, Optional.empty());
    }

    @JsonIgnore
    public List<VerifyM2MTokenErrors> errors() {
        return this.errors;
    }

    @JsonIgnore
    public Optional<HttpResponse<InputStream>> rawResponse() {
        return this.rawResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerifyM2MTokenResponseBody withErrors(List<VerifyM2MTokenErrors> errors) {
        Utils.checkNotNull(errors, "errors");
        this.errors = errors;
        return this;
    }

    public VerifyM2MTokenResponseBody withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = Optional.ofNullable(rawResponse);
        return this;
    }

    public VerifyM2MTokenResponseBody withRawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyM2MTokenResponseBody other = (VerifyM2MTokenResponseBody)o;
        return Utils.enhancedDeepEquals(this.errors, other.errors) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.errors, this.rawResponse);
    }

    @Override
    public String toString() {
        return Utils.toString(VerifyM2MTokenResponseBody.class, "errors", this.errors, "rawResponse", this.rawResponse);
    }

    public static final class Builder {
        private List<VerifyM2MTokenErrors> errors;
        private Optional<? extends HttpResponse<InputStream>> rawResponse;

        private Builder() {
        }

        public Builder errors(List<VerifyM2MTokenErrors> errors) {
            Utils.checkNotNull(errors, "errors");
            this.errors = errors;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = Optional.ofNullable(rawResponse);
            return this;
        }

        public Builder rawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public VerifyM2MTokenResponseBody build() {
            return new VerifyM2MTokenResponseBody(this.errors, this.rawResponse);
        }
    }
}

