/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.errors;

import com.clerk.backend_api.models.errors.VerifyOAuthAccessTokenErrors;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;

public class VerifyOAuthAccessTokenResponseBody
extends RuntimeException {
    @JsonProperty(value="errors")
    private List<VerifyOAuthAccessTokenErrors> errors;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="RawResponse")
    private Optional<? extends HttpResponse<InputStream>> rawResponse;

    @JsonCreator
    public VerifyOAuthAccessTokenResponseBody(@JsonProperty(value="errors") List<VerifyOAuthAccessTokenErrors> errors, @JsonProperty(value="RawResponse") Optional<? extends HttpResponse<InputStream>> rawResponse) {
        super("API error occurred");
        Utils.checkNotNull(errors, "errors");
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.errors = errors;
        this.rawResponse = rawResponse;
    }

    public VerifyOAuthAccessTokenResponseBody(List<VerifyOAuthAccessTokenErrors> errors) {
        this(errors, Optional.empty());
    }

    @JsonIgnore
    public List<VerifyOAuthAccessTokenErrors> errors() {
        return this.errors;
    }

    @JsonIgnore
    public Optional<HttpResponse<InputStream>> rawResponse() {
        return this.rawResponse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerifyOAuthAccessTokenResponseBody withErrors(List<VerifyOAuthAccessTokenErrors> errors) {
        Utils.checkNotNull(errors, "errors");
        this.errors = errors;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = Optional.ofNullable(rawResponse);
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withRawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyOAuthAccessTokenResponseBody other = (VerifyOAuthAccessTokenResponseBody)o;
        return Utils.enhancedDeepEquals(this.errors, other.errors) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.errors, this.rawResponse);
    }

    @Override
    public String toString() {
        return Utils.toString(VerifyOAuthAccessTokenResponseBody.class, "errors", this.errors, "rawResponse", this.rawResponse);
    }

    public static final class Builder {
        private List<VerifyOAuthAccessTokenErrors> errors;
        private Optional<? extends HttpResponse<InputStream>> rawResponse;

        private Builder() {
        }

        public Builder errors(List<VerifyOAuthAccessTokenErrors> errors) {
            Utils.checkNotNull(errors, "errors");
            this.errors = errors;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = Optional.ofNullable(rawResponse);
            return this;
        }

        public Builder rawResponse(Optional<? extends HttpResponse<InputStream>> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public VerifyOAuthAccessTokenResponseBody build() {
            return new VerifyOAuthAccessTokenResponseBody(this.errors, this.rawResponse);
        }
    }
}

