/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.openapitools.jackson.nullable.JsonNullable;

public class AddDomainRequestBody {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="is_satellite")
    private boolean isSatellite;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="proxy_url")
    private JsonNullable<String> proxyUrl;

    @JsonCreator
    public AddDomainRequestBody(@JsonProperty(value="name") String name, @JsonProperty(value="is_satellite") boolean isSatellite, @JsonProperty(value="proxy_url") JsonNullable<String> proxyUrl) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(isSatellite, "isSatellite");
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.name = name;
        this.isSatellite = isSatellite;
        this.proxyUrl = proxyUrl;
    }

    public AddDomainRequestBody(String name, boolean isSatellite) {
        this(name, isSatellite, (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public boolean isSatellite() {
        return this.isSatellite;
    }

    @JsonIgnore
    public JsonNullable<String> proxyUrl() {
        return this.proxyUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AddDomainRequestBody withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public AddDomainRequestBody withIsSatellite(boolean isSatellite) {
        Utils.checkNotNull(isSatellite, "isSatellite");
        this.isSatellite = isSatellite;
        return this;
    }

    public AddDomainRequestBody withProxyUrl(String proxyUrl) {
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.proxyUrl = JsonNullable.of((Object)proxyUrl);
        return this;
    }

    public AddDomainRequestBody withProxyUrl(JsonNullable<String> proxyUrl) {
        Utils.checkNotNull(proxyUrl, "proxyUrl");
        this.proxyUrl = proxyUrl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddDomainRequestBody other = (AddDomainRequestBody)o;
        return Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.isSatellite, other.isSatellite) && Utils.enhancedDeepEquals(this.proxyUrl, other.proxyUrl);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.name, this.isSatellite, this.proxyUrl);
    }

    public String toString() {
        return Utils.toString(AddDomainRequestBody.class, "name", this.name, "isSatellite", this.isSatellite, "proxyUrl", this.proxyUrl);
    }

    public static final class Builder {
        private String name;
        private Boolean isSatellite;
        private JsonNullable<String> proxyUrl = JsonNullable.undefined();

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder isSatellite(boolean isSatellite) {
            Utils.checkNotNull(isSatellite, "isSatellite");
            this.isSatellite = isSatellite;
            return this;
        }

        public Builder proxyUrl(String proxyUrl) {
            Utils.checkNotNull(proxyUrl, "proxyUrl");
            this.proxyUrl = JsonNullable.of((Object)proxyUrl);
            return this;
        }

        public Builder proxyUrl(JsonNullable<String> proxyUrl) {
            Utils.checkNotNull(proxyUrl, "proxyUrl");
            this.proxyUrl = proxyUrl;
            return this;
        }

        public AddDomainRequestBody build() {
            return new AddDomainRequestBody(this.name, this.isSatellite, this.proxyUrl);
        }
    }
}

