/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class CancelCommerceSubscriptionItemRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=subscription_item_id")
    private String subscriptionItemId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=end_now")
    private Optional<Boolean> endNow;

    @JsonCreator
    public CancelCommerceSubscriptionItemRequest(String subscriptionItemId, Optional<Boolean> endNow) {
        Utils.checkNotNull(subscriptionItemId, "subscriptionItemId");
        Utils.checkNotNull(endNow, "endNow");
        this.subscriptionItemId = subscriptionItemId;
        this.endNow = endNow;
    }

    public CancelCommerceSubscriptionItemRequest(String subscriptionItemId) {
        this(subscriptionItemId, Optional.empty());
    }

    @JsonIgnore
    public String subscriptionItemId() {
        return this.subscriptionItemId;
    }

    @JsonIgnore
    public Optional<Boolean> endNow() {
        return this.endNow;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CancelCommerceSubscriptionItemRequest withSubscriptionItemId(String subscriptionItemId) {
        Utils.checkNotNull(subscriptionItemId, "subscriptionItemId");
        this.subscriptionItemId = subscriptionItemId;
        return this;
    }

    public CancelCommerceSubscriptionItemRequest withEndNow(boolean endNow) {
        Utils.checkNotNull(endNow, "endNow");
        this.endNow = Optional.ofNullable(endNow);
        return this;
    }

    public CancelCommerceSubscriptionItemRequest withEndNow(Optional<Boolean> endNow) {
        Utils.checkNotNull(endNow, "endNow");
        this.endNow = endNow;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelCommerceSubscriptionItemRequest other = (CancelCommerceSubscriptionItemRequest)o;
        return Utils.enhancedDeepEquals(this.subscriptionItemId, other.subscriptionItemId) && Utils.enhancedDeepEquals(this.endNow, other.endNow);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.subscriptionItemId, this.endNow);
    }

    public String toString() {
        return Utils.toString(CancelCommerceSubscriptionItemRequest.class, "subscriptionItemId", this.subscriptionItemId, "endNow", this.endNow);
    }

    public static final class Builder {
        private String subscriptionItemId;
        private Optional<Boolean> endNow;
        private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_EndNow = new LazySingletonValue<Optional<Boolean>>("end_now", "false", new TypeReference<Optional<Boolean>>(){});

        private Builder() {
        }

        public Builder subscriptionItemId(String subscriptionItemId) {
            Utils.checkNotNull(subscriptionItemId, "subscriptionItemId");
            this.subscriptionItemId = subscriptionItemId;
            return this;
        }

        public Builder endNow(boolean endNow) {
            Utils.checkNotNull(endNow, "endNow");
            this.endNow = Optional.ofNullable(endNow);
            return this;
        }

        public Builder endNow(Optional<Boolean> endNow) {
            Utils.checkNotNull(endNow, "endNow");
            this.endNow = endNow;
            return this;
        }

        public CancelCommerceSubscriptionItemRequest build() {
            if (this.endNow == null) {
                this.endNow = _SINGLETON_VALUE_EndNow.value();
            }
            return new CancelCommerceSubscriptionItemRequest(this.subscriptionItemId, this.endNow);
        }
    }
}

