/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CancelCommerceSubscriptionItemRequest;
import com.clerk.backend_api.models.operations.CancelCommerceSubscriptionItemResponse;
import com.clerk.backend_api.operations.CancelCommerceSubscriptionItem;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class CancelCommerceSubscriptionItemRequestBuilder {
    private String subscriptionItemId;
    private Optional<Boolean> endNow = Utils.readDefaultOrConstValue("endNow", "false", new TypeReference<Optional<Boolean>>(){});
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private static final LazySingletonValue<Optional<Boolean>> _SINGLETON_VALUE_EndNow = new LazySingletonValue<Optional<Boolean>>("endNow", "false", new TypeReference<Optional<Boolean>>(){});

    public CancelCommerceSubscriptionItemRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CancelCommerceSubscriptionItemRequestBuilder subscriptionItemId(String subscriptionItemId) {
        Utils.checkNotNull(subscriptionItemId, "subscriptionItemId");
        this.subscriptionItemId = subscriptionItemId;
        return this;
    }

    public CancelCommerceSubscriptionItemRequestBuilder endNow(boolean endNow) {
        Utils.checkNotNull(endNow, "endNow");
        this.endNow = Optional.of(endNow);
        return this;
    }

    public CancelCommerceSubscriptionItemRequestBuilder endNow(Optional<Boolean> endNow) {
        Utils.checkNotNull(endNow, "endNow");
        this.endNow = endNow;
        return this;
    }

    public CancelCommerceSubscriptionItemRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CancelCommerceSubscriptionItemRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private CancelCommerceSubscriptionItemRequest buildRequest() {
        if (this.endNow == null) {
            this.endNow = _SINGLETON_VALUE_EndNow.value();
        }
        CancelCommerceSubscriptionItemRequest request = new CancelCommerceSubscriptionItemRequest(this.subscriptionItemId, this.endNow);
        return request;
    }

    public CancelCommerceSubscriptionItemResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CancelCommerceSubscriptionItem.Sync operation = new CancelCommerceSubscriptionItem.Sync(this.sdkConfiguration, options);
        CancelCommerceSubscriptionItemRequest request = this.buildRequest();
        return (CancelCommerceSubscriptionItemResponse)operation.handleResponse(operation.doRequest(request));
    }
}

