/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.AccountlessApplication;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class CreateAccountlessApplicationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AccountlessApplication> accountlessApplication;

    @JsonCreator
    public CreateAccountlessApplicationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AccountlessApplication> accountlessApplication) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountlessApplication, "accountlessApplication");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountlessApplication = accountlessApplication;
    }

    public CreateAccountlessApplicationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountlessApplication> accountlessApplication() {
        return this.accountlessApplication;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateAccountlessApplicationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateAccountlessApplicationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateAccountlessApplicationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateAccountlessApplicationResponse withAccountlessApplication(AccountlessApplication accountlessApplication) {
        Utils.checkNotNull(accountlessApplication, "accountlessApplication");
        this.accountlessApplication = Optional.ofNullable(accountlessApplication);
        return this;
    }

    public CreateAccountlessApplicationResponse withAccountlessApplication(Optional<? extends AccountlessApplication> accountlessApplication) {
        Utils.checkNotNull(accountlessApplication, "accountlessApplication");
        this.accountlessApplication = accountlessApplication;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAccountlessApplicationResponse other = (CreateAccountlessApplicationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountlessApplication, other.accountlessApplication);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountlessApplication);
    }

    public String toString() {
        return Utils.toString(CreateAccountlessApplicationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountlessApplication", this.accountlessApplication);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AccountlessApplication> accountlessApplication = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountlessApplication(AccountlessApplication accountlessApplication) {
            Utils.checkNotNull(accountlessApplication, "accountlessApplication");
            this.accountlessApplication = Optional.ofNullable(accountlessApplication);
            return this;
        }

        public Builder accountlessApplication(Optional<? extends AccountlessApplication> accountlessApplication) {
            Utils.checkNotNull(accountlessApplication, "accountlessApplication");
            this.accountlessApplication = accountlessApplication;
            return this;
        }

        public CreateAccountlessApplicationResponse build() {
            return new CreateAccountlessApplicationResponse(this.contentType, this.statusCode, this.rawResponse, this.accountlessApplication);
        }
    }
}

