/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.AllowlistIdentifier;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class CreateAllowlistIdentifierResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AllowlistIdentifier> allowlistIdentifier;

    @JsonCreator
    public CreateAllowlistIdentifierResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AllowlistIdentifier> allowlistIdentifier) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(allowlistIdentifier, "allowlistIdentifier");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.allowlistIdentifier = allowlistIdentifier;
    }

    public CreateAllowlistIdentifierResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AllowlistIdentifier> allowlistIdentifier() {
        return this.allowlistIdentifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateAllowlistIdentifierResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateAllowlistIdentifierResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateAllowlistIdentifierResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateAllowlistIdentifierResponse withAllowlistIdentifier(AllowlistIdentifier allowlistIdentifier) {
        Utils.checkNotNull(allowlistIdentifier, "allowlistIdentifier");
        this.allowlistIdentifier = Optional.ofNullable(allowlistIdentifier);
        return this;
    }

    public CreateAllowlistIdentifierResponse withAllowlistIdentifier(Optional<? extends AllowlistIdentifier> allowlistIdentifier) {
        Utils.checkNotNull(allowlistIdentifier, "allowlistIdentifier");
        this.allowlistIdentifier = allowlistIdentifier;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAllowlistIdentifierResponse other = (CreateAllowlistIdentifierResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.allowlistIdentifier, other.allowlistIdentifier);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.allowlistIdentifier);
    }

    public String toString() {
        return Utils.toString(CreateAllowlistIdentifierResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "allowlistIdentifier", this.allowlistIdentifier);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AllowlistIdentifier> allowlistIdentifier = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder allowlistIdentifier(AllowlistIdentifier allowlistIdentifier) {
            Utils.checkNotNull(allowlistIdentifier, "allowlistIdentifier");
            this.allowlistIdentifier = Optional.ofNullable(allowlistIdentifier);
            return this;
        }

        public Builder allowlistIdentifier(Optional<? extends AllowlistIdentifier> allowlistIdentifier) {
            Utils.checkNotNull(allowlistIdentifier, "allowlistIdentifier");
            this.allowlistIdentifier = allowlistIdentifier;
            return this;
        }

        public CreateAllowlistIdentifierResponse build() {
            return new CreateAllowlistIdentifierResponse(this.contentType, this.statusCode, this.rawResponse, this.allowlistIdentifier);
        }
    }
}

