/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.BlocklistIdentifier;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class CreateBlocklistIdentifierResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends BlocklistIdentifier> blocklistIdentifier;

    @JsonCreator
    public CreateBlocklistIdentifierResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends BlocklistIdentifier> blocklistIdentifier) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(blocklistIdentifier, "blocklistIdentifier");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.blocklistIdentifier = blocklistIdentifier;
    }

    public CreateBlocklistIdentifierResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<BlocklistIdentifier> blocklistIdentifier() {
        return this.blocklistIdentifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateBlocklistIdentifierResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateBlocklistIdentifierResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateBlocklistIdentifierResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateBlocklistIdentifierResponse withBlocklistIdentifier(BlocklistIdentifier blocklistIdentifier) {
        Utils.checkNotNull(blocklistIdentifier, "blocklistIdentifier");
        this.blocklistIdentifier = Optional.ofNullable(blocklistIdentifier);
        return this;
    }

    public CreateBlocklistIdentifierResponse withBlocklistIdentifier(Optional<? extends BlocklistIdentifier> blocklistIdentifier) {
        Utils.checkNotNull(blocklistIdentifier, "blocklistIdentifier");
        this.blocklistIdentifier = blocklistIdentifier;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateBlocklistIdentifierResponse other = (CreateBlocklistIdentifierResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.blocklistIdentifier, other.blocklistIdentifier);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.blocklistIdentifier);
    }

    public String toString() {
        return Utils.toString(CreateBlocklistIdentifierResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "blocklistIdentifier", this.blocklistIdentifier);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends BlocklistIdentifier> blocklistIdentifier = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder blocklistIdentifier(BlocklistIdentifier blocklistIdentifier) {
            Utils.checkNotNull(blocklistIdentifier, "blocklistIdentifier");
            this.blocklistIdentifier = Optional.ofNullable(blocklistIdentifier);
            return this;
        }

        public Builder blocklistIdentifier(Optional<? extends BlocklistIdentifier> blocklistIdentifier) {
            Utils.checkNotNull(blocklistIdentifier, "blocklistIdentifier");
            this.blocklistIdentifier = blocklistIdentifier;
            return this;
        }

        public CreateBlocklistIdentifierResponse build() {
            return new CreateBlocklistIdentifierResponse(this.contentType, this.statusCode, this.rawResponse, this.blocklistIdentifier);
        }
    }
}

