/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateEmailAddressRequestBody {
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="email_address")
    private String emailAddress;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified")
    private JsonNullable<Boolean> verified;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="primary")
    private JsonNullable<Boolean> primary;

    @JsonCreator
    public CreateEmailAddressRequestBody(@JsonProperty(value="user_id") String userId, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="verified") JsonNullable<Boolean> verified, @JsonProperty(value="primary") JsonNullable<Boolean> primary) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(emailAddress, "emailAddress");
        Utils.checkNotNull(verified, "verified");
        Utils.checkNotNull(primary, "primary");
        this.userId = userId;
        this.emailAddress = emailAddress;
        this.verified = verified;
        this.primary = primary;
    }

    public CreateEmailAddressRequestBody(String userId, String emailAddress) {
        this(userId, emailAddress, (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String emailAddress() {
        return this.emailAddress;
    }

    @JsonIgnore
    public JsonNullable<Boolean> verified() {
        return this.verified;
    }

    @JsonIgnore
    public JsonNullable<Boolean> primary() {
        return this.primary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateEmailAddressRequestBody withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public CreateEmailAddressRequestBody withEmailAddress(String emailAddress) {
        Utils.checkNotNull(emailAddress, "emailAddress");
        this.emailAddress = emailAddress;
        return this;
    }

    public CreateEmailAddressRequestBody withVerified(boolean verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = JsonNullable.of((Object)verified);
        return this;
    }

    public CreateEmailAddressRequestBody withVerified(JsonNullable<Boolean> verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = verified;
        return this;
    }

    public CreateEmailAddressRequestBody withPrimary(boolean primary) {
        Utils.checkNotNull(primary, "primary");
        this.primary = JsonNullable.of((Object)primary);
        return this;
    }

    public CreateEmailAddressRequestBody withPrimary(JsonNullable<Boolean> primary) {
        Utils.checkNotNull(primary, "primary");
        this.primary = primary;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateEmailAddressRequestBody other = (CreateEmailAddressRequestBody)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.emailAddress, other.emailAddress) && Utils.enhancedDeepEquals(this.verified, other.verified) && Utils.enhancedDeepEquals(this.primary, other.primary);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.emailAddress, this.verified, this.primary);
    }

    public String toString() {
        return Utils.toString(CreateEmailAddressRequestBody.class, "userId", this.userId, "emailAddress", this.emailAddress, "verified", this.verified, "primary", this.primary);
    }

    public static final class Builder {
        private String userId;
        private String emailAddress;
        private JsonNullable<Boolean> verified = JsonNullable.undefined();
        private JsonNullable<Boolean> primary = JsonNullable.undefined();

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            Utils.checkNotNull(emailAddress, "emailAddress");
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder verified(boolean verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = JsonNullable.of((Object)verified);
            return this;
        }

        public Builder verified(JsonNullable<Boolean> verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = verified;
            return this;
        }

        public Builder primary(boolean primary) {
            Utils.checkNotNull(primary, "primary");
            this.primary = JsonNullable.of((Object)primary);
            return this;
        }

        public Builder primary(JsonNullable<Boolean> primary) {
            Utils.checkNotNull(primary, "primary");
            this.primary = primary;
            return this;
        }

        public CreateEmailAddressRequestBody build() {
            return new CreateEmailAddressRequestBody(this.userId, this.emailAddress, this.verified, this.primary);
        }
    }
}

