/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;

public class CreateMachineRequestBody {
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="scoped_machines")
    private Optional<? extends List<String>> scopedMachines;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="default_token_ttl")
    private Optional<Long> defaultTokenTtl;

    @JsonCreator
    public CreateMachineRequestBody(@JsonProperty(value="name") String name, @JsonProperty(value="scoped_machines") Optional<? extends List<String>> scopedMachines, @JsonProperty(value="default_token_ttl") Optional<Long> defaultTokenTtl) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(scopedMachines, "scopedMachines");
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.name = name;
        this.scopedMachines = scopedMachines;
        this.defaultTokenTtl = defaultTokenTtl;
    }

    public CreateMachineRequestBody(String name) {
        this(name, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public Optional<List<String>> scopedMachines() {
        return this.scopedMachines;
    }

    @JsonIgnore
    public Optional<Long> defaultTokenTtl() {
        return this.defaultTokenTtl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateMachineRequestBody withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public CreateMachineRequestBody withScopedMachines(List<String> scopedMachines) {
        Utils.checkNotNull(scopedMachines, "scopedMachines");
        this.scopedMachines = Optional.ofNullable(scopedMachines);
        return this;
    }

    public CreateMachineRequestBody withScopedMachines(Optional<? extends List<String>> scopedMachines) {
        Utils.checkNotNull(scopedMachines, "scopedMachines");
        this.scopedMachines = scopedMachines;
        return this;
    }

    public CreateMachineRequestBody withDefaultTokenTtl(long defaultTokenTtl) {
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.defaultTokenTtl = Optional.ofNullable(defaultTokenTtl);
        return this;
    }

    public CreateMachineRequestBody withDefaultTokenTtl(Optional<Long> defaultTokenTtl) {
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.defaultTokenTtl = defaultTokenTtl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMachineRequestBody other = (CreateMachineRequestBody)o;
        return Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.scopedMachines, other.scopedMachines) && Utils.enhancedDeepEquals(this.defaultTokenTtl, other.defaultTokenTtl);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.name, this.scopedMachines, this.defaultTokenTtl);
    }

    public String toString() {
        return Utils.toString(CreateMachineRequestBody.class, "name", this.name, "scopedMachines", this.scopedMachines, "defaultTokenTtl", this.defaultTokenTtl);
    }

    public static final class Builder {
        private String name;
        private Optional<? extends List<String>> scopedMachines = Optional.empty();
        private Optional<Long> defaultTokenTtl;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_DefaultTokenTtl = new LazySingletonValue<Optional<Long>>("default_token_ttl", "3600", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder scopedMachines(List<String> scopedMachines) {
            Utils.checkNotNull(scopedMachines, "scopedMachines");
            this.scopedMachines = Optional.ofNullable(scopedMachines);
            return this;
        }

        public Builder scopedMachines(Optional<? extends List<String>> scopedMachines) {
            Utils.checkNotNull(scopedMachines, "scopedMachines");
            this.scopedMachines = scopedMachines;
            return this;
        }

        public Builder defaultTokenTtl(long defaultTokenTtl) {
            Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
            this.defaultTokenTtl = Optional.ofNullable(defaultTokenTtl);
            return this;
        }

        public Builder defaultTokenTtl(Optional<Long> defaultTokenTtl) {
            Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
            this.defaultTokenTtl = defaultTokenTtl;
            return this;
        }

        public CreateMachineRequestBody build() {
            if (this.defaultTokenTtl == null) {
                this.defaultTokenTtl = _SINGLETON_VALUE_DefaultTokenTtl.value();
            }
            return new CreateMachineRequestBody(this.name, this.scopedMachines, this.defaultTokenTtl);
        }
    }
}

