/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateMachineRequestBody;
import com.clerk.backend_api.models.operations.CreateMachineResponse;
import com.clerk.backend_api.operations.CreateMachine;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class CreateMachineRequestBuilder {
    private Optional<? extends CreateMachineRequestBody> request = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public CreateMachineRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateMachineRequestBuilder request(CreateMachineRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = Optional.of(request);
        return this;
    }

    public CreateMachineRequestBuilder request(Optional<? extends CreateMachineRequestBody> request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public CreateMachineRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CreateMachineRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CreateMachineResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CreateMachine.Sync operation = new CreateMachine.Sync(this.sdkConfiguration, options);
        return (CreateMachineResponse)operation.handleResponse(operation.doRequest(this.request));
    }
}

