/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.MachineCreated;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class CreateMachineResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MachineCreated> machineCreated;

    @JsonCreator
    public CreateMachineResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MachineCreated> machineCreated) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(machineCreated, "machineCreated");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.machineCreated = machineCreated;
    }

    public CreateMachineResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MachineCreated> machineCreated() {
        return this.machineCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateMachineResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateMachineResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateMachineResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateMachineResponse withMachineCreated(MachineCreated machineCreated) {
        Utils.checkNotNull(machineCreated, "machineCreated");
        this.machineCreated = Optional.ofNullable(machineCreated);
        return this;
    }

    public CreateMachineResponse withMachineCreated(Optional<? extends MachineCreated> machineCreated) {
        Utils.checkNotNull(machineCreated, "machineCreated");
        this.machineCreated = machineCreated;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMachineResponse other = (CreateMachineResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.machineCreated, other.machineCreated);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.machineCreated);
    }

    public String toString() {
        return Utils.toString(CreateMachineResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "machineCreated", this.machineCreated);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MachineCreated> machineCreated = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder machineCreated(MachineCreated machineCreated) {
            Utils.checkNotNull(machineCreated, "machineCreated");
            this.machineCreated = Optional.ofNullable(machineCreated);
            return this;
        }

        public Builder machineCreated(Optional<? extends MachineCreated> machineCreated) {
            Utils.checkNotNull(machineCreated, "machineCreated");
            this.machineCreated = machineCreated;
            return this;
        }

        public CreateMachineResponse build() {
            return new CreateMachineResponse(this.contentType, this.statusCode, this.rawResponse, this.machineCreated);
        }
    }
}

