/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateMachineScopeRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class CreateMachineScopeRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=machine_id")
    private String machineId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends CreateMachineScopeRequestBody> requestBody;

    @JsonCreator
    public CreateMachineScopeRequest(String machineId, Optional<? extends CreateMachineScopeRequestBody> requestBody) {
        Utils.checkNotNull(machineId, "machineId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.machineId = machineId;
        this.requestBody = requestBody;
    }

    public CreateMachineScopeRequest(String machineId) {
        this(machineId, Optional.empty());
    }

    @JsonIgnore
    public String machineId() {
        return this.machineId;
    }

    @JsonIgnore
    public Optional<CreateMachineScopeRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateMachineScopeRequest withMachineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public CreateMachineScopeRequest withRequestBody(CreateMachineScopeRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public CreateMachineScopeRequest withRequestBody(Optional<? extends CreateMachineScopeRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMachineScopeRequest other = (CreateMachineScopeRequest)o;
        return Utils.enhancedDeepEquals(this.machineId, other.machineId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.machineId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(CreateMachineScopeRequest.class, "machineId", this.machineId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String machineId;
        private Optional<? extends CreateMachineScopeRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder machineId(String machineId) {
            Utils.checkNotNull(machineId, "machineId");
            this.machineId = machineId;
            return this;
        }

        public Builder requestBody(CreateMachineScopeRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends CreateMachineScopeRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public CreateMachineScopeRequest build() {
            return new CreateMachineScopeRequest(this.machineId, this.requestBody);
        }
    }
}

