/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateMachineScopeRequest;
import com.clerk.backend_api.models.operations.CreateMachineScopeRequestBody;
import com.clerk.backend_api.models.operations.CreateMachineScopeResponse;
import com.clerk.backend_api.operations.CreateMachineScope;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class CreateMachineScopeRequestBuilder {
    private String machineId;
    private Optional<? extends CreateMachineScopeRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public CreateMachineScopeRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateMachineScopeRequestBuilder machineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public CreateMachineScopeRequestBuilder requestBody(CreateMachineScopeRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public CreateMachineScopeRequestBuilder requestBody(Optional<? extends CreateMachineScopeRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public CreateMachineScopeRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CreateMachineScopeRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private CreateMachineScopeRequest buildRequest() {
        CreateMachineScopeRequest request = new CreateMachineScopeRequest(this.machineId, this.requestBody);
        return request;
    }

    public CreateMachineScopeResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CreateMachineScope.Sync operation = new CreateMachineScope.Sync(this.sdkConfiguration, options);
        CreateMachineScopeRequest request = this.buildRequest();
        return (CreateMachineScopeResponse)operation.handleResponse(operation.doRequest(request));
    }
}

