/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.MachineScope;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class CreateMachineScopeResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MachineScope> machineScope;

    @JsonCreator
    public CreateMachineScopeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MachineScope> machineScope) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(machineScope, "machineScope");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.machineScope = machineScope;
    }

    public CreateMachineScopeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MachineScope> machineScope() {
        return this.machineScope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateMachineScopeResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateMachineScopeResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateMachineScopeResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateMachineScopeResponse withMachineScope(MachineScope machineScope) {
        Utils.checkNotNull(machineScope, "machineScope");
        this.machineScope = Optional.ofNullable(machineScope);
        return this;
    }

    public CreateMachineScopeResponse withMachineScope(Optional<? extends MachineScope> machineScope) {
        Utils.checkNotNull(machineScope, "machineScope");
        this.machineScope = machineScope;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMachineScopeResponse other = (CreateMachineScopeResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.machineScope, other.machineScope);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.machineScope);
    }

    public String toString() {
        return Utils.toString(CreateMachineScopeResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "machineScope", this.machineScope);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MachineScope> machineScope = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder machineScope(MachineScope machineScope) {
            Utils.checkNotNull(machineScope, "machineScope");
            this.machineScope = Optional.ofNullable(machineScope);
            return this;
        }

        public Builder machineScope(Optional<? extends MachineScope> machineScope) {
            Utils.checkNotNull(machineScope, "machineScope");
            this.machineScope = machineScope;
            return this;
        }

        public CreateMachineScopeResponse build() {
            return new CreateMachineScopeResponse(this.contentType, this.statusCode, this.rawResponse, this.machineScope);
        }
    }
}

