/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateOAuthApplicationRequestBody {
    @JsonProperty(value="name")
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="redirect_uris")
    private JsonNullable<? extends List<String>> redirectUris;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="callback_url")
    @Deprecated
    private JsonNullable<String> callbackUrl;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="scopes")
    private JsonNullable<String> scopes;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="consent_screen_enabled")
    private JsonNullable<Boolean> consentScreenEnabled;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="pkce_required")
    private JsonNullable<Boolean> pkceRequired;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="public")
    private JsonNullable<Boolean> public_;

    @JsonCreator
    public CreateOAuthApplicationRequestBody(@JsonProperty(value="name") String name, @JsonProperty(value="redirect_uris") JsonNullable<? extends List<String>> redirectUris, @JsonProperty(value="callback_url") JsonNullable<String> callbackUrl, @JsonProperty(value="scopes") JsonNullable<String> scopes, @JsonProperty(value="consent_screen_enabled") JsonNullable<Boolean> consentScreenEnabled, @JsonProperty(value="pkce_required") JsonNullable<Boolean> pkceRequired, @JsonProperty(value="public") JsonNullable<Boolean> public_) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(redirectUris, "redirectUris");
        Utils.checkNotNull(callbackUrl, "callbackUrl");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
        Utils.checkNotNull(pkceRequired, "pkceRequired");
        Utils.checkNotNull(public_, "public_");
        this.name = name;
        this.redirectUris = redirectUris;
        this.callbackUrl = callbackUrl;
        this.scopes = scopes;
        this.consentScreenEnabled = consentScreenEnabled;
        this.pkceRequired = pkceRequired;
        this.public_ = public_;
    }

    public CreateOAuthApplicationRequestBody(String name) {
        this(name, (JsonNullable<? extends List<String>>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String name() {
        return this.name;
    }

    @JsonIgnore
    public JsonNullable<List<String>> redirectUris() {
        return this.redirectUris;
    }

    @Deprecated
    @JsonIgnore
    public JsonNullable<String> callbackUrl() {
        return this.callbackUrl;
    }

    @JsonIgnore
    public JsonNullable<String> scopes() {
        return this.scopes;
    }

    @JsonIgnore
    public JsonNullable<Boolean> consentScreenEnabled() {
        return this.consentScreenEnabled;
    }

    @JsonIgnore
    public JsonNullable<Boolean> pkceRequired() {
        return this.pkceRequired;
    }

    @JsonIgnore
    public JsonNullable<Boolean> public_() {
        return this.public_;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateOAuthApplicationRequestBody withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public CreateOAuthApplicationRequestBody withRedirectUris(List<String> redirectUris) {
        Utils.checkNotNull(redirectUris, "redirectUris");
        this.redirectUris = JsonNullable.of(redirectUris);
        return this;
    }

    public CreateOAuthApplicationRequestBody withRedirectUris(JsonNullable<? extends List<String>> redirectUris) {
        Utils.checkNotNull(redirectUris, "redirectUris");
        this.redirectUris = redirectUris;
        return this;
    }

    @Deprecated
    public CreateOAuthApplicationRequestBody withCallbackUrl(String callbackUrl) {
        Utils.checkNotNull(callbackUrl, "callbackUrl");
        this.callbackUrl = JsonNullable.of((Object)callbackUrl);
        return this;
    }

    @Deprecated
    public CreateOAuthApplicationRequestBody withCallbackUrl(JsonNullable<String> callbackUrl) {
        Utils.checkNotNull(callbackUrl, "callbackUrl");
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CreateOAuthApplicationRequestBody withScopes(String scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = JsonNullable.of((Object)scopes);
        return this;
    }

    public CreateOAuthApplicationRequestBody withScopes(JsonNullable<String> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public CreateOAuthApplicationRequestBody withConsentScreenEnabled(boolean consentScreenEnabled) {
        Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
        this.consentScreenEnabled = JsonNullable.of((Object)consentScreenEnabled);
        return this;
    }

    public CreateOAuthApplicationRequestBody withConsentScreenEnabled(JsonNullable<Boolean> consentScreenEnabled) {
        Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
        this.consentScreenEnabled = consentScreenEnabled;
        return this;
    }

    public CreateOAuthApplicationRequestBody withPkceRequired(boolean pkceRequired) {
        Utils.checkNotNull(pkceRequired, "pkceRequired");
        this.pkceRequired = JsonNullable.of((Object)pkceRequired);
        return this;
    }

    public CreateOAuthApplicationRequestBody withPkceRequired(JsonNullable<Boolean> pkceRequired) {
        Utils.checkNotNull(pkceRequired, "pkceRequired");
        this.pkceRequired = pkceRequired;
        return this;
    }

    public CreateOAuthApplicationRequestBody withPublic(boolean public_) {
        Utils.checkNotNull(public_, "public_");
        this.public_ = JsonNullable.of((Object)public_);
        return this;
    }

    public CreateOAuthApplicationRequestBody withPublic(JsonNullable<Boolean> public_) {
        Utils.checkNotNull(public_, "public_");
        this.public_ = public_;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOAuthApplicationRequestBody other = (CreateOAuthApplicationRequestBody)o;
        return Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.redirectUris, other.redirectUris) && Utils.enhancedDeepEquals(this.callbackUrl, other.callbackUrl) && Utils.enhancedDeepEquals(this.scopes, other.scopes) && Utils.enhancedDeepEquals(this.consentScreenEnabled, other.consentScreenEnabled) && Utils.enhancedDeepEquals(this.pkceRequired, other.pkceRequired) && Utils.enhancedDeepEquals(this.public_, other.public_);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.name, this.redirectUris, this.callbackUrl, this.scopes, this.consentScreenEnabled, this.pkceRequired, this.public_);
    }

    public String toString() {
        return Utils.toString(CreateOAuthApplicationRequestBody.class, "name", this.name, "redirectUris", this.redirectUris, "callbackUrl", this.callbackUrl, "scopes", this.scopes, "consentScreenEnabled", this.consentScreenEnabled, "pkceRequired", this.pkceRequired, "public_", this.public_);
    }

    public static final class Builder {
        private String name;
        private JsonNullable<? extends List<String>> redirectUris = JsonNullable.undefined();
        @Deprecated
        private JsonNullable<String> callbackUrl = JsonNullable.undefined();
        private JsonNullable<String> scopes;
        private JsonNullable<Boolean> consentScreenEnabled;
        private JsonNullable<Boolean> pkceRequired;
        private JsonNullable<Boolean> public_ = JsonNullable.undefined();
        private static final LazySingletonValue<JsonNullable<String>> _SINGLETON_VALUE_Scopes = new LazySingletonValue<JsonNullable<String>>("scopes", "\"profile email\"", new TypeReference<JsonNullable<String>>(){});
        private static final LazySingletonValue<JsonNullable<Boolean>> _SINGLETON_VALUE_ConsentScreenEnabled = new LazySingletonValue<JsonNullable<Boolean>>("consent_screen_enabled", "true", new TypeReference<JsonNullable<Boolean>>(){});
        private static final LazySingletonValue<JsonNullable<Boolean>> _SINGLETON_VALUE_PkceRequired = new LazySingletonValue<JsonNullable<Boolean>>("pkce_required", "false", new TypeReference<JsonNullable<Boolean>>(){});

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder redirectUris(List<String> redirectUris) {
            Utils.checkNotNull(redirectUris, "redirectUris");
            this.redirectUris = JsonNullable.of(redirectUris);
            return this;
        }

        public Builder redirectUris(JsonNullable<? extends List<String>> redirectUris) {
            Utils.checkNotNull(redirectUris, "redirectUris");
            this.redirectUris = redirectUris;
            return this;
        }

        @Deprecated
        public Builder callbackUrl(String callbackUrl) {
            Utils.checkNotNull(callbackUrl, "callbackUrl");
            this.callbackUrl = JsonNullable.of((Object)callbackUrl);
            return this;
        }

        @Deprecated
        public Builder callbackUrl(JsonNullable<String> callbackUrl) {
            Utils.checkNotNull(callbackUrl, "callbackUrl");
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder scopes(String scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = JsonNullable.of((Object)scopes);
            return this;
        }

        public Builder scopes(JsonNullable<String> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder consentScreenEnabled(boolean consentScreenEnabled) {
            Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
            this.consentScreenEnabled = JsonNullable.of((Object)consentScreenEnabled);
            return this;
        }

        public Builder consentScreenEnabled(JsonNullable<Boolean> consentScreenEnabled) {
            Utils.checkNotNull(consentScreenEnabled, "consentScreenEnabled");
            this.consentScreenEnabled = consentScreenEnabled;
            return this;
        }

        public Builder pkceRequired(boolean pkceRequired) {
            Utils.checkNotNull(pkceRequired, "pkceRequired");
            this.pkceRequired = JsonNullable.of((Object)pkceRequired);
            return this;
        }

        public Builder pkceRequired(JsonNullable<Boolean> pkceRequired) {
            Utils.checkNotNull(pkceRequired, "pkceRequired");
            this.pkceRequired = pkceRequired;
            return this;
        }

        public Builder public_(boolean public_) {
            Utils.checkNotNull(public_, "public_");
            this.public_ = JsonNullable.of((Object)public_);
            return this;
        }

        public Builder public_(JsonNullable<Boolean> public_) {
            Utils.checkNotNull(public_, "public_");
            this.public_ = public_;
            return this;
        }

        public CreateOAuthApplicationRequestBody build() {
            if (this.scopes == null) {
                this.scopes = _SINGLETON_VALUE_Scopes.value();
            }
            if (this.consentScreenEnabled == null) {
                this.consentScreenEnabled = _SINGLETON_VALUE_ConsentScreenEnabled.value();
            }
            if (this.pkceRequired == null) {
                this.pkceRequired = _SINGLETON_VALUE_PkceRequired.value();
            }
            return new CreateOAuthApplicationRequestBody(this.name, this.redirectUris, this.callbackUrl, this.scopes, this.consentScreenEnabled, this.pkceRequired, this.public_);
        }
    }
}

