/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreateOrganizationDomainRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private Optional<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="enrollment_mode")
    private Optional<String> enrollmentMode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified")
    private JsonNullable<Boolean> verified;

    @JsonCreator
    public CreateOrganizationDomainRequestBody(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="enrollment_mode") Optional<String> enrollmentMode, @JsonProperty(value="verified") JsonNullable<Boolean> verified) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        Utils.checkNotNull(verified, "verified");
        this.name = name;
        this.enrollmentMode = enrollmentMode;
        this.verified = verified;
    }

    public CreateOrganizationDomainRequestBody() {
        this(Optional.empty(), Optional.empty(), (JsonNullable<Boolean>)JsonNullable.undefined());
    }

    @JsonIgnore
    public Optional<String> name() {
        return this.name;
    }

    @JsonIgnore
    public Optional<String> enrollmentMode() {
        return this.enrollmentMode;
    }

    @JsonIgnore
    public JsonNullable<Boolean> verified() {
        return this.verified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateOrganizationDomainRequestBody withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public CreateOrganizationDomainRequestBody withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public CreateOrganizationDomainRequestBody withEnrollmentMode(String enrollmentMode) {
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        this.enrollmentMode = Optional.ofNullable(enrollmentMode);
        return this;
    }

    public CreateOrganizationDomainRequestBody withEnrollmentMode(Optional<String> enrollmentMode) {
        Utils.checkNotNull(enrollmentMode, "enrollmentMode");
        this.enrollmentMode = enrollmentMode;
        return this;
    }

    public CreateOrganizationDomainRequestBody withVerified(boolean verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = JsonNullable.of((Object)verified);
        return this;
    }

    public CreateOrganizationDomainRequestBody withVerified(JsonNullable<Boolean> verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = verified;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrganizationDomainRequestBody other = (CreateOrganizationDomainRequestBody)o;
        return Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.enrollmentMode, other.enrollmentMode) && Utils.enhancedDeepEquals(this.verified, other.verified);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.name, this.enrollmentMode, this.verified);
    }

    public String toString() {
        return Utils.toString(CreateOrganizationDomainRequestBody.class, "name", this.name, "enrollmentMode", this.enrollmentMode, "verified", this.verified);
    }

    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> enrollmentMode = Optional.empty();
        private JsonNullable<Boolean> verified = JsonNullable.undefined();

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder enrollmentMode(String enrollmentMode) {
            Utils.checkNotNull(enrollmentMode, "enrollmentMode");
            this.enrollmentMode = Optional.ofNullable(enrollmentMode);
            return this;
        }

        public Builder enrollmentMode(Optional<String> enrollmentMode) {
            Utils.checkNotNull(enrollmentMode, "enrollmentMode");
            this.enrollmentMode = enrollmentMode;
            return this;
        }

        public Builder verified(boolean verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = JsonNullable.of((Object)verified);
            return this;
        }

        public Builder verified(JsonNullable<Boolean> verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = verified;
            return this;
        }

        public CreateOrganizationDomainRequestBody build() {
            return new CreateOrganizationDomainRequestBody(this.name, this.enrollmentMode, this.verified);
        }
    }
}

