/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainRequestBody;
import com.clerk.backend_api.models.operations.CreateOrganizationDomainResponse;
import com.clerk.backend_api.operations.CreateOrganizationDomain;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class CreateOrganizationDomainRequestBuilder {
    private String organizationId;
    private CreateOrganizationDomainRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public CreateOrganizationDomainRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateOrganizationDomainRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public CreateOrganizationDomainRequestBuilder requestBody(CreateOrganizationDomainRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public CreateOrganizationDomainRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CreateOrganizationDomainRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private CreateOrganizationDomainRequest buildRequest() {
        CreateOrganizationDomainRequest request = new CreateOrganizationDomainRequest(this.organizationId, this.requestBody);
        return request;
    }

    public CreateOrganizationDomainResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CreateOrganizationDomain.Sync operation = new CreateOrganizationDomain.Sync(this.sdkConfiguration, options);
        CreateOrganizationDomainRequest request = this.buildRequest();
        return (CreateOrganizationDomainResponse)operation.handleResponse(operation.doRequest(request));
    }
}

