/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateOrganizationInvitationBulkRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

public class CreateOrganizationInvitationBulkRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private List<CreateOrganizationInvitationBulkRequestBody> requestBody;

    @JsonCreator
    public CreateOrganizationInvitationBulkRequest(String organizationId, List<CreateOrganizationInvitationBulkRequestBody> requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public List<CreateOrganizationInvitationBulkRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateOrganizationInvitationBulkRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public CreateOrganizationInvitationBulkRequest withRequestBody(List<CreateOrganizationInvitationBulkRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrganizationInvitationBulkRequest other = (CreateOrganizationInvitationBulkRequest)o;
        return Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.organizationId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(CreateOrganizationInvitationBulkRequest.class, "organizationId", this.organizationId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private List<CreateOrganizationInvitationBulkRequestBody> requestBody;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder requestBody(List<CreateOrganizationInvitationBulkRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public CreateOrganizationInvitationBulkRequest build() {
            return new CreateOrganizationInvitationBulkRequest(this.organizationId, this.requestBody);
        }
    }
}

