/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateOrganizationInvitationRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class CreateOrganizationInvitationRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends CreateOrganizationInvitationRequestBody> requestBody;

    @JsonCreator
    public CreateOrganizationInvitationRequest(String organizationId, Optional<? extends CreateOrganizationInvitationRequestBody> requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.requestBody = requestBody;
    }

    public CreateOrganizationInvitationRequest(String organizationId) {
        this(organizationId, Optional.empty());
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<CreateOrganizationInvitationRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateOrganizationInvitationRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public CreateOrganizationInvitationRequest withRequestBody(CreateOrganizationInvitationRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public CreateOrganizationInvitationRequest withRequestBody(Optional<? extends CreateOrganizationInvitationRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrganizationInvitationRequest other = (CreateOrganizationInvitationRequest)o;
        return Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.organizationId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(CreateOrganizationInvitationRequest.class, "organizationId", this.organizationId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private Optional<? extends CreateOrganizationInvitationRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder requestBody(CreateOrganizationInvitationRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends CreateOrganizationInvitationRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public CreateOrganizationInvitationRequest build() {
            return new CreateOrganizationInvitationRequest(this.organizationId, this.requestBody);
        }
    }
}

