/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CreateOrganizationMembershipRequestBody {
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="role")
    private String role;

    @JsonCreator
    public CreateOrganizationMembershipRequestBody(@JsonProperty(value="user_id") String userId, @JsonProperty(value="role") String role) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(role, "role");
        this.userId = userId;
        this.role = role;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String role() {
        return this.role;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateOrganizationMembershipRequestBody withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public CreateOrganizationMembershipRequestBody withRole(String role) {
        Utils.checkNotNull(role, "role");
        this.role = role;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrganizationMembershipRequestBody other = (CreateOrganizationMembershipRequestBody)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.role, other.role);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.role);
    }

    public String toString() {
        return Utils.toString(CreateOrganizationMembershipRequestBody.class, "userId", this.userId, "role", this.role);
    }

    public static final class Builder {
        private String userId;
        private String role;

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder role(String role) {
            Utils.checkNotNull(role, "role");
            this.role = role;
            return this;
        }

        public CreateOrganizationMembershipRequestBody build() {
            return new CreateOrganizationMembershipRequestBody(this.userId, this.role);
        }
    }
}

