/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.openapitools.jackson.nullable.JsonNullable;

public class CreatePhoneNumberRequestBody {
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="phone_number")
    private String phoneNumber;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified")
    private JsonNullable<Boolean> verified;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="primary")
    private JsonNullable<Boolean> primary;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="reserved_for_second_factor")
    private JsonNullable<Boolean> reservedForSecondFactor;

    @JsonCreator
    public CreatePhoneNumberRequestBody(@JsonProperty(value="user_id") String userId, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="verified") JsonNullable<Boolean> verified, @JsonProperty(value="primary") JsonNullable<Boolean> primary, @JsonProperty(value="reserved_for_second_factor") JsonNullable<Boolean> reservedForSecondFactor) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(verified, "verified");
        Utils.checkNotNull(primary, "primary");
        Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
        this.userId = userId;
        this.phoneNumber = phoneNumber;
        this.verified = verified;
        this.primary = primary;
        this.reservedForSecondFactor = reservedForSecondFactor;
    }

    public CreatePhoneNumberRequestBody(String userId, String phoneNumber) {
        this(userId, phoneNumber, (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined(), (JsonNullable<Boolean>)JsonNullable.undefined());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @JsonIgnore
    public JsonNullable<Boolean> verified() {
        return this.verified;
    }

    @JsonIgnore
    public JsonNullable<Boolean> primary() {
        return this.primary;
    }

    @JsonIgnore
    public JsonNullable<Boolean> reservedForSecondFactor() {
        return this.reservedForSecondFactor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreatePhoneNumberRequestBody withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public CreatePhoneNumberRequestBody withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    public CreatePhoneNumberRequestBody withVerified(boolean verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = JsonNullable.of((Object)verified);
        return this;
    }

    public CreatePhoneNumberRequestBody withVerified(JsonNullable<Boolean> verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = verified;
        return this;
    }

    public CreatePhoneNumberRequestBody withPrimary(boolean primary) {
        Utils.checkNotNull(primary, "primary");
        this.primary = JsonNullable.of((Object)primary);
        return this;
    }

    public CreatePhoneNumberRequestBody withPrimary(JsonNullable<Boolean> primary) {
        Utils.checkNotNull(primary, "primary");
        this.primary = primary;
        return this;
    }

    public CreatePhoneNumberRequestBody withReservedForSecondFactor(boolean reservedForSecondFactor) {
        Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
        this.reservedForSecondFactor = JsonNullable.of((Object)reservedForSecondFactor);
        return this;
    }

    public CreatePhoneNumberRequestBody withReservedForSecondFactor(JsonNullable<Boolean> reservedForSecondFactor) {
        Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
        this.reservedForSecondFactor = reservedForSecondFactor;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePhoneNumberRequestBody other = (CreatePhoneNumberRequestBody)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.phoneNumber, other.phoneNumber) && Utils.enhancedDeepEquals(this.verified, other.verified) && Utils.enhancedDeepEquals(this.primary, other.primary) && Utils.enhancedDeepEquals(this.reservedForSecondFactor, other.reservedForSecondFactor);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.phoneNumber, this.verified, this.primary, this.reservedForSecondFactor);
    }

    public String toString() {
        return Utils.toString(CreatePhoneNumberRequestBody.class, "userId", this.userId, "phoneNumber", this.phoneNumber, "verified", this.verified, "primary", this.primary, "reservedForSecondFactor", this.reservedForSecondFactor);
    }

    public static final class Builder {
        private String userId;
        private String phoneNumber;
        private JsonNullable<Boolean> verified = JsonNullable.undefined();
        private JsonNullable<Boolean> primary = JsonNullable.undefined();
        private JsonNullable<Boolean> reservedForSecondFactor = JsonNullable.undefined();

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder verified(boolean verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = JsonNullable.of((Object)verified);
            return this;
        }

        public Builder verified(JsonNullable<Boolean> verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = verified;
            return this;
        }

        public Builder primary(boolean primary) {
            Utils.checkNotNull(primary, "primary");
            this.primary = JsonNullable.of((Object)primary);
            return this;
        }

        public Builder primary(JsonNullable<Boolean> primary) {
            Utils.checkNotNull(primary, "primary");
            this.primary = primary;
            return this;
        }

        public Builder reservedForSecondFactor(boolean reservedForSecondFactor) {
            Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
            this.reservedForSecondFactor = JsonNullable.of((Object)reservedForSecondFactor);
            return this;
        }

        public Builder reservedForSecondFactor(JsonNullable<Boolean> reservedForSecondFactor) {
            Utils.checkNotNull(reservedForSecondFactor, "reservedForSecondFactor");
            this.reservedForSecondFactor = reservedForSecondFactor;
            return this;
        }

        public CreatePhoneNumberRequestBody build() {
            return new CreatePhoneNumberRequestBody(this.userId, this.phoneNumber, this.verified, this.primary, this.reservedForSecondFactor);
        }
    }
}

