/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CreateSessionTokenFromTemplateRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class CreateSessionTokenFromTemplateRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=session_id")
    private String sessionId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_name")
    private String templateName;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends CreateSessionTokenFromTemplateRequestBody> requestBody;

    @JsonCreator
    public CreateSessionTokenFromTemplateRequest(String sessionId, String templateName, Optional<? extends CreateSessionTokenFromTemplateRequestBody> requestBody) {
        Utils.checkNotNull(sessionId, "sessionId");
        Utils.checkNotNull(templateName, "templateName");
        Utils.checkNotNull(requestBody, "requestBody");
        this.sessionId = sessionId;
        this.templateName = templateName;
        this.requestBody = requestBody;
    }

    public CreateSessionTokenFromTemplateRequest(String sessionId, String templateName) {
        this(sessionId, templateName, Optional.empty());
    }

    @JsonIgnore
    public String sessionId() {
        return this.sessionId;
    }

    @JsonIgnore
    public String templateName() {
        return this.templateName;
    }

    @JsonIgnore
    public Optional<CreateSessionTokenFromTemplateRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateSessionTokenFromTemplateRequest withSessionId(String sessionId) {
        Utils.checkNotNull(sessionId, "sessionId");
        this.sessionId = sessionId;
        return this;
    }

    public CreateSessionTokenFromTemplateRequest withTemplateName(String templateName) {
        Utils.checkNotNull(templateName, "templateName");
        this.templateName = templateName;
        return this;
    }

    public CreateSessionTokenFromTemplateRequest withRequestBody(CreateSessionTokenFromTemplateRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public CreateSessionTokenFromTemplateRequest withRequestBody(Optional<? extends CreateSessionTokenFromTemplateRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSessionTokenFromTemplateRequest other = (CreateSessionTokenFromTemplateRequest)o;
        return Utils.enhancedDeepEquals(this.sessionId, other.sessionId) && Utils.enhancedDeepEquals(this.templateName, other.templateName) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.sessionId, this.templateName, this.requestBody);
    }

    public String toString() {
        return Utils.toString(CreateSessionTokenFromTemplateRequest.class, "sessionId", this.sessionId, "templateName", this.templateName, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String sessionId;
        private String templateName;
        private Optional<? extends CreateSessionTokenFromTemplateRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder sessionId(String sessionId) {
            Utils.checkNotNull(sessionId, "sessionId");
            this.sessionId = sessionId;
            return this;
        }

        public Builder templateName(String templateName) {
            Utils.checkNotNull(templateName, "templateName");
            this.templateName = templateName;
            return this;
        }

        public Builder requestBody(CreateSessionTokenFromTemplateRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends CreateSessionTokenFromTemplateRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public CreateSessionTokenFromTemplateRequest build() {
            return new CreateSessionTokenFromTemplateRequest(this.sessionId, this.templateName, this.requestBody);
        }
    }
}

