/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequest;
import com.clerk.backend_api.models.operations.CreateSessionTokenRequestBody;
import com.clerk.backend_api.models.operations.CreateSessionTokenResponse;
import com.clerk.backend_api.operations.CreateSessionToken;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class CreateSessionTokenRequestBuilder {
    private String sessionId;
    private Optional<? extends CreateSessionTokenRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public CreateSessionTokenRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public CreateSessionTokenRequestBuilder sessionId(String sessionId) {
        Utils.checkNotNull(sessionId, "sessionId");
        this.sessionId = sessionId;
        return this;
    }

    public CreateSessionTokenRequestBuilder requestBody(CreateSessionTokenRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public CreateSessionTokenRequestBuilder requestBody(Optional<? extends CreateSessionTokenRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public CreateSessionTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CreateSessionTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private CreateSessionTokenRequest buildRequest() {
        CreateSessionTokenRequest request = new CreateSessionTokenRequest(this.sessionId, this.requestBody);
        return request;
    }

    public CreateSessionTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        CreateSessionToken.Sync operation = new CreateSessionToken.Sync(this.sdkConfiguration, options);
        CreateSessionTokenRequest request = this.buildRequest();
        return (CreateSessionTokenResponse)operation.handleResponse(operation.doRequest(request));
    }
}

