/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.WaitlistEntry;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class CreateWaitlistEntryResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends WaitlistEntry> waitlistEntry;

    @JsonCreator
    public CreateWaitlistEntryResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends WaitlistEntry> waitlistEntry) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(waitlistEntry, "waitlistEntry");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.waitlistEntry = waitlistEntry;
    }

    public CreateWaitlistEntryResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<WaitlistEntry> waitlistEntry() {
        return this.waitlistEntry;
    }

    public static Builder builder() {
        return new Builder();
    }

    public CreateWaitlistEntryResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public CreateWaitlistEntryResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public CreateWaitlistEntryResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public CreateWaitlistEntryResponse withWaitlistEntry(WaitlistEntry waitlistEntry) {
        Utils.checkNotNull(waitlistEntry, "waitlistEntry");
        this.waitlistEntry = Optional.ofNullable(waitlistEntry);
        return this;
    }

    public CreateWaitlistEntryResponse withWaitlistEntry(Optional<? extends WaitlistEntry> waitlistEntry) {
        Utils.checkNotNull(waitlistEntry, "waitlistEntry");
        this.waitlistEntry = waitlistEntry;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWaitlistEntryResponse other = (CreateWaitlistEntryResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.waitlistEntry, other.waitlistEntry);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.waitlistEntry);
    }

    public String toString() {
        return Utils.toString(CreateWaitlistEntryResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "waitlistEntry", this.waitlistEntry);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends WaitlistEntry> waitlistEntry = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder waitlistEntry(WaitlistEntry waitlistEntry) {
            Utils.checkNotNull(waitlistEntry, "waitlistEntry");
            this.waitlistEntry = Optional.ofNullable(waitlistEntry);
            return this;
        }

        public Builder waitlistEntry(Optional<? extends WaitlistEntry> waitlistEntry) {
            Utils.checkNotNull(waitlistEntry, "waitlistEntry");
            this.waitlistEntry = waitlistEntry;
            return this;
        }

        public CreateWaitlistEntryResponse build() {
            return new CreateWaitlistEntryResponse(this.contentType, this.statusCode, this.rawResponse, this.waitlistEntry);
        }
    }
}

