/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteAWSCredentialRequest;
import com.clerk.backend_api.models.operations.DeleteAWSCredentialResponse;
import com.clerk.backend_api.operations.DeleteAWSCredential;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteAWSCredentialRequestBuilder {
    private String id;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteAWSCredentialRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteAWSCredentialRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public DeleteAWSCredentialRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteAWSCredentialRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteAWSCredentialRequest buildRequest() {
        DeleteAWSCredentialRequest request = new DeleteAWSCredentialRequest(this.id);
        return request;
    }

    public DeleteAWSCredentialResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteAWSCredential.Sync operation = new DeleteAWSCredential.Sync(this.sdkConfiguration, options);
        DeleteAWSCredentialRequest request = this.buildRequest();
        return (DeleteAWSCredentialResponse)operation.handleResponse(operation.doRequest(request));
    }
}

