/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.DeletedObject;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class DeleteAWSCredentialResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends DeletedObject> deletedObject;

    @JsonCreator
    public DeleteAWSCredentialResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends DeletedObject> deletedObject) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(deletedObject, "deletedObject");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.deletedObject = deletedObject;
    }

    public DeleteAWSCredentialResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<DeletedObject> deletedObject() {
        return this.deletedObject;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeleteAWSCredentialResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public DeleteAWSCredentialResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public DeleteAWSCredentialResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public DeleteAWSCredentialResponse withDeletedObject(DeletedObject deletedObject) {
        Utils.checkNotNull(deletedObject, "deletedObject");
        this.deletedObject = Optional.ofNullable(deletedObject);
        return this;
    }

    public DeleteAWSCredentialResponse withDeletedObject(Optional<? extends DeletedObject> deletedObject) {
        Utils.checkNotNull(deletedObject, "deletedObject");
        this.deletedObject = deletedObject;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteAWSCredentialResponse other = (DeleteAWSCredentialResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.deletedObject, other.deletedObject);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.deletedObject);
    }

    public String toString() {
        return Utils.toString(DeleteAWSCredentialResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "deletedObject", this.deletedObject);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends DeletedObject> deletedObject = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder deletedObject(DeletedObject deletedObject) {
            Utils.checkNotNull(deletedObject, "deletedObject");
            this.deletedObject = Optional.ofNullable(deletedObject);
            return this;
        }

        public Builder deletedObject(Optional<? extends DeletedObject> deletedObject) {
            Utils.checkNotNull(deletedObject, "deletedObject");
            this.deletedObject = deletedObject;
            return this;
        }

        public DeleteAWSCredentialResponse build() {
            return new DeleteAWSCredentialResponse(this.contentType, this.statusCode, this.rawResponse, this.deletedObject);
        }
    }
}

