/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteBackupCodeRequest;
import com.clerk.backend_api.models.operations.DeleteBackupCodeResponse;
import com.clerk.backend_api.operations.DeleteBackupCode;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteBackupCodeRequestBuilder {
    private String userId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteBackupCodeRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteBackupCodeRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public DeleteBackupCodeRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteBackupCodeRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteBackupCodeRequest buildRequest() {
        DeleteBackupCodeRequest request = new DeleteBackupCodeRequest(this.userId);
        return request;
    }

    public DeleteBackupCodeResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteBackupCode.Sync operation = new DeleteBackupCode.Sync(this.sdkConfiguration, options);
        DeleteBackupCodeRequest request = this.buildRequest();
        return (DeleteBackupCodeResponse)operation.handleResponse(operation.doRequest(request));
    }
}

