/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteDomainRequest;
import com.clerk.backend_api.models.operations.DeleteDomainResponse;
import com.clerk.backend_api.operations.DeleteDomain;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteDomainRequestBuilder {
    private String domainId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteDomainRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteDomainRequestBuilder domainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public DeleteDomainRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteDomainRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteDomainRequest buildRequest() {
        DeleteDomainRequest request = new DeleteDomainRequest(this.domainId);
        return request;
    }

    public DeleteDomainResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteDomain.Sync operation = new DeleteDomain.Sync(this.sdkConfiguration, options);
        DeleteDomainRequest request = this.buildRequest();
        return (DeleteDomainResponse)operation.handleResponse(operation.doRequest(request));
    }
}

