/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteEmailAddressRequest;
import com.clerk.backend_api.models.operations.DeleteEmailAddressResponse;
import com.clerk.backend_api.operations.DeleteEmailAddress;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteEmailAddressRequestBuilder {
    private String emailAddressId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteEmailAddressRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteEmailAddressRequestBuilder emailAddressId(String emailAddressId) {
        Utils.checkNotNull(emailAddressId, "emailAddressId");
        this.emailAddressId = emailAddressId;
        return this;
    }

    public DeleteEmailAddressRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteEmailAddressRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteEmailAddressRequest buildRequest() {
        DeleteEmailAddressRequest request = new DeleteEmailAddressRequest(this.emailAddressId);
        return request;
    }

    public DeleteEmailAddressResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteEmailAddress.Sync operation = new DeleteEmailAddress.Sync(this.sdkConfiguration, options);
        DeleteEmailAddressRequest request = this.buildRequest();
        return (DeleteEmailAddressResponse)operation.handleResponse(operation.doRequest(request));
    }
}

