/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class DeleteExternalAccountRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=external_account_id")
    private String externalAccountId;

    @JsonCreator
    public DeleteExternalAccountRequest(String userId, String externalAccountId) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        this.userId = userId;
        this.externalAccountId = externalAccountId;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String externalAccountId() {
        return this.externalAccountId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeleteExternalAccountRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public DeleteExternalAccountRequest withExternalAccountId(String externalAccountId) {
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        this.externalAccountId = externalAccountId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteExternalAccountRequest other = (DeleteExternalAccountRequest)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.externalAccountId, other.externalAccountId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.externalAccountId);
    }

    public String toString() {
        return Utils.toString(DeleteExternalAccountRequest.class, "userId", this.userId, "externalAccountId", this.externalAccountId);
    }

    public static final class Builder {
        private String userId;
        private String externalAccountId;

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder externalAccountId(String externalAccountId) {
            Utils.checkNotNull(externalAccountId, "externalAccountId");
            this.externalAccountId = externalAccountId;
            return this;
        }

        public DeleteExternalAccountRequest build() {
            return new DeleteExternalAccountRequest(this.userId, this.externalAccountId);
        }
    }
}

