/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteExternalAccountRequest;
import com.clerk.backend_api.models.operations.DeleteExternalAccountResponse;
import com.clerk.backend_api.operations.DeleteExternalAccount;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteExternalAccountRequestBuilder {
    private String userId;
    private String externalAccountId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteExternalAccountRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteExternalAccountRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public DeleteExternalAccountRequestBuilder externalAccountId(String externalAccountId) {
        Utils.checkNotNull(externalAccountId, "externalAccountId");
        this.externalAccountId = externalAccountId;
        return this;
    }

    public DeleteExternalAccountRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteExternalAccountRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteExternalAccountRequest buildRequest() {
        DeleteExternalAccountRequest request = new DeleteExternalAccountRequest(this.userId, this.externalAccountId);
        return request;
    }

    public DeleteExternalAccountResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteExternalAccount.Sync operation = new DeleteExternalAccount.Sync(this.sdkConfiguration, options);
        DeleteExternalAccountRequest request = this.buildRequest();
        return (DeleteExternalAccountResponse)operation.handleResponse(operation.doRequest(request));
    }
}

