/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteJWTTemplateRequest;
import com.clerk.backend_api.models.operations.DeleteJWTTemplateResponse;
import com.clerk.backend_api.operations.DeleteJWTTemplate;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteJWTTemplateRequestBuilder {
    private String templateId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteJWTTemplateRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteJWTTemplateRequestBuilder templateId(String templateId) {
        Utils.checkNotNull(templateId, "templateId");
        this.templateId = templateId;
        return this;
    }

    public DeleteJWTTemplateRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteJWTTemplateRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteJWTTemplateRequest buildRequest() {
        DeleteJWTTemplateRequest request = new DeleteJWTTemplateRequest(this.templateId);
        return request;
    }

    public DeleteJWTTemplateResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteJWTTemplate.Sync operation = new DeleteJWTTemplate.Sync(this.sdkConfiguration, options);
        DeleteJWTTemplateRequest request = this.buildRequest();
        return (DeleteJWTTemplateResponse)operation.handleResponse(operation.doRequest(request));
    }
}

