/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteMachineRequest;
import com.clerk.backend_api.models.operations.DeleteMachineResponse;
import com.clerk.backend_api.operations.DeleteMachine;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteMachineRequestBuilder {
    private String machineId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteMachineRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteMachineRequestBuilder machineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public DeleteMachineRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteMachineRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteMachineRequest buildRequest() {
        DeleteMachineRequest request = new DeleteMachineRequest(this.machineId);
        return request;
    }

    public DeleteMachineResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteMachine.Sync operation = new DeleteMachine.Sync(this.sdkConfiguration, options);
        DeleteMachineRequest request = this.buildRequest();
        return (DeleteMachineResponse)operation.handleResponse(operation.doRequest(request));
    }
}

