/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.MachineDeleted;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class DeleteMachineResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MachineDeleted> machineDeleted;

    @JsonCreator
    public DeleteMachineResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MachineDeleted> machineDeleted) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(machineDeleted, "machineDeleted");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.machineDeleted = machineDeleted;
    }

    public DeleteMachineResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MachineDeleted> machineDeleted() {
        return this.machineDeleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeleteMachineResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public DeleteMachineResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public DeleteMachineResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public DeleteMachineResponse withMachineDeleted(MachineDeleted machineDeleted) {
        Utils.checkNotNull(machineDeleted, "machineDeleted");
        this.machineDeleted = Optional.ofNullable(machineDeleted);
        return this;
    }

    public DeleteMachineResponse withMachineDeleted(Optional<? extends MachineDeleted> machineDeleted) {
        Utils.checkNotNull(machineDeleted, "machineDeleted");
        this.machineDeleted = machineDeleted;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteMachineResponse other = (DeleteMachineResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.machineDeleted, other.machineDeleted);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.machineDeleted);
    }

    public String toString() {
        return Utils.toString(DeleteMachineResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "machineDeleted", this.machineDeleted);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MachineDeleted> machineDeleted = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder machineDeleted(MachineDeleted machineDeleted) {
            Utils.checkNotNull(machineDeleted, "machineDeleted");
            this.machineDeleted = Optional.ofNullable(machineDeleted);
            return this;
        }

        public Builder machineDeleted(Optional<? extends MachineDeleted> machineDeleted) {
            Utils.checkNotNull(machineDeleted, "machineDeleted");
            this.machineDeleted = machineDeleted;
            return this;
        }

        public DeleteMachineResponse build() {
            return new DeleteMachineResponse(this.contentType, this.statusCode, this.rawResponse, this.machineDeleted);
        }
    }
}

