/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class DeleteMachineScopeRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=machine_id")
    private String machineId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=other_machine_id")
    private String otherMachineId;

    @JsonCreator
    public DeleteMachineScopeRequest(String machineId, String otherMachineId) {
        Utils.checkNotNull(machineId, "machineId");
        Utils.checkNotNull(otherMachineId, "otherMachineId");
        this.machineId = machineId;
        this.otherMachineId = otherMachineId;
    }

    @JsonIgnore
    public String machineId() {
        return this.machineId;
    }

    @JsonIgnore
    public String otherMachineId() {
        return this.otherMachineId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeleteMachineScopeRequest withMachineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public DeleteMachineScopeRequest withOtherMachineId(String otherMachineId) {
        Utils.checkNotNull(otherMachineId, "otherMachineId");
        this.otherMachineId = otherMachineId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteMachineScopeRequest other = (DeleteMachineScopeRequest)o;
        return Utils.enhancedDeepEquals(this.machineId, other.machineId) && Utils.enhancedDeepEquals(this.otherMachineId, other.otherMachineId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.machineId, this.otherMachineId);
    }

    public String toString() {
        return Utils.toString(DeleteMachineScopeRequest.class, "machineId", this.machineId, "otherMachineId", this.otherMachineId);
    }

    public static final class Builder {
        private String machineId;
        private String otherMachineId;

        private Builder() {
        }

        public Builder machineId(String machineId) {
            Utils.checkNotNull(machineId, "machineId");
            this.machineId = machineId;
            return this;
        }

        public Builder otherMachineId(String otherMachineId) {
            Utils.checkNotNull(otherMachineId, "otherMachineId");
            this.otherMachineId = otherMachineId;
            return this;
        }

        public DeleteMachineScopeRequest build() {
            return new DeleteMachineScopeRequest(this.machineId, this.otherMachineId);
        }
    }
}

