/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteMachineScopeRequest;
import com.clerk.backend_api.models.operations.DeleteMachineScopeResponse;
import com.clerk.backend_api.operations.DeleteMachineScope;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteMachineScopeRequestBuilder {
    private String machineId;
    private String otherMachineId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteMachineScopeRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteMachineScopeRequestBuilder machineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public DeleteMachineScopeRequestBuilder otherMachineId(String otherMachineId) {
        Utils.checkNotNull(otherMachineId, "otherMachineId");
        this.otherMachineId = otherMachineId;
        return this;
    }

    public DeleteMachineScopeRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteMachineScopeRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteMachineScopeRequest buildRequest() {
        DeleteMachineScopeRequest request = new DeleteMachineScopeRequest(this.machineId, this.otherMachineId);
        return request;
    }

    public DeleteMachineScopeResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteMachineScope.Sync operation = new DeleteMachineScope.Sync(this.sdkConfiguration, options);
        DeleteMachineScopeRequest request = this.buildRequest();
        return (DeleteMachineScopeResponse)operation.handleResponse(operation.doRequest(request));
    }
}

