/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.MachineScopeDeleted;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class DeleteMachineScopeResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends MachineScopeDeleted> machineScopeDeleted;

    @JsonCreator
    public DeleteMachineScopeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends MachineScopeDeleted> machineScopeDeleted) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(machineScopeDeleted, "machineScopeDeleted");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.machineScopeDeleted = machineScopeDeleted;
    }

    public DeleteMachineScopeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<MachineScopeDeleted> machineScopeDeleted() {
        return this.machineScopeDeleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeleteMachineScopeResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public DeleteMachineScopeResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public DeleteMachineScopeResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public DeleteMachineScopeResponse withMachineScopeDeleted(MachineScopeDeleted machineScopeDeleted) {
        Utils.checkNotNull(machineScopeDeleted, "machineScopeDeleted");
        this.machineScopeDeleted = Optional.ofNullable(machineScopeDeleted);
        return this;
    }

    public DeleteMachineScopeResponse withMachineScopeDeleted(Optional<? extends MachineScopeDeleted> machineScopeDeleted) {
        Utils.checkNotNull(machineScopeDeleted, "machineScopeDeleted");
        this.machineScopeDeleted = machineScopeDeleted;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteMachineScopeResponse other = (DeleteMachineScopeResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.machineScopeDeleted, other.machineScopeDeleted);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.machineScopeDeleted);
    }

    public String toString() {
        return Utils.toString(DeleteMachineScopeResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "machineScopeDeleted", this.machineScopeDeleted);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends MachineScopeDeleted> machineScopeDeleted = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder machineScopeDeleted(MachineScopeDeleted machineScopeDeleted) {
            Utils.checkNotNull(machineScopeDeleted, "machineScopeDeleted");
            this.machineScopeDeleted = Optional.ofNullable(machineScopeDeleted);
            return this;
        }

        public Builder machineScopeDeleted(Optional<? extends MachineScopeDeleted> machineScopeDeleted) {
            Utils.checkNotNull(machineScopeDeleted, "machineScopeDeleted");
            this.machineScopeDeleted = machineScopeDeleted;
            return this;
        }

        public DeleteMachineScopeResponse build() {
            return new DeleteMachineScopeResponse(this.contentType, this.statusCode, this.rawResponse, this.machineScopeDeleted);
        }
    }
}

