/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteOAuthApplicationRequest;
import com.clerk.backend_api.models.operations.DeleteOAuthApplicationResponse;
import com.clerk.backend_api.operations.DeleteOAuthApplication;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteOAuthApplicationRequestBuilder {
    private String oauthApplicationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteOAuthApplicationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteOAuthApplicationRequestBuilder oauthApplicationId(String oauthApplicationId) {
        Utils.checkNotNull(oauthApplicationId, "oauthApplicationId");
        this.oauthApplicationId = oauthApplicationId;
        return this;
    }

    public DeleteOAuthApplicationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteOAuthApplicationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteOAuthApplicationRequest buildRequest() {
        DeleteOAuthApplicationRequest request = new DeleteOAuthApplicationRequest(this.oauthApplicationId);
        return request;
    }

    public DeleteOAuthApplicationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteOAuthApplication.Sync operation = new DeleteOAuthApplication.Sync(this.sdkConfiguration, options);
        DeleteOAuthApplicationRequest request = this.buildRequest();
        return (DeleteOAuthApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

