/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class DeleteOrganizationDomainRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=domain_id")
    private String domainId;

    @JsonCreator
    public DeleteOrganizationDomainRequest(String organizationId, String domainId) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(domainId, "domainId");
        this.organizationId = organizationId;
        this.domainId = domainId;
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String domainId() {
        return this.domainId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeleteOrganizationDomainRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public DeleteOrganizationDomainRequest withDomainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteOrganizationDomainRequest other = (DeleteOrganizationDomainRequest)o;
        return Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.domainId, other.domainId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.organizationId, this.domainId);
    }

    public String toString() {
        return Utils.toString(DeleteOrganizationDomainRequest.class, "organizationId", this.organizationId, "domainId", this.domainId);
    }

    public static final class Builder {
        private String organizationId;
        private String domainId;

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder domainId(String domainId) {
            Utils.checkNotNull(domainId, "domainId");
            this.domainId = domainId;
            return this;
        }

        public DeleteOrganizationDomainRequest build() {
            return new DeleteOrganizationDomainRequest(this.organizationId, this.domainId);
        }
    }
}

