/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationDomainResponse;
import com.clerk.backend_api.operations.DeleteOrganizationDomain;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteOrganizationDomainRequestBuilder {
    private String organizationId;
    private String domainId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteOrganizationDomainRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteOrganizationDomainRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public DeleteOrganizationDomainRequestBuilder domainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public DeleteOrganizationDomainRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteOrganizationDomainRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteOrganizationDomainRequest buildRequest() {
        DeleteOrganizationDomainRequest request = new DeleteOrganizationDomainRequest(this.organizationId, this.domainId);
        return request;
    }

    public DeleteOrganizationDomainResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteOrganizationDomain.Sync operation = new DeleteOrganizationDomain.Sync(this.sdkConfiguration, options);
        DeleteOrganizationDomainRequest request = this.buildRequest();
        return (DeleteOrganizationDomainResponse)operation.handleResponse(operation.doRequest(request));
    }
}

