/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteOrganizationLogoRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationLogoResponse;
import com.clerk.backend_api.operations.DeleteOrganizationLogo;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteOrganizationLogoRequestBuilder {
    private String organizationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteOrganizationLogoRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteOrganizationLogoRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public DeleteOrganizationLogoRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteOrganizationLogoRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteOrganizationLogoRequest buildRequest() {
        DeleteOrganizationLogoRequest request = new DeleteOrganizationLogoRequest(this.organizationId);
        return request;
    }

    public DeleteOrganizationLogoResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteOrganizationLogo.Sync operation = new DeleteOrganizationLogo.Sync(this.sdkConfiguration, options);
        DeleteOrganizationLogoRequest request = this.buildRequest();
        return (DeleteOrganizationLogoResponse)operation.handleResponse(operation.doRequest(request));
    }
}

