/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteOrganizationMembershipRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationMembershipResponse;
import com.clerk.backend_api.operations.DeleteOrganizationMembership;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteOrganizationMembershipRequestBuilder {
    private String organizationId;
    private String userId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteOrganizationMembershipRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteOrganizationMembershipRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public DeleteOrganizationMembershipRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public DeleteOrganizationMembershipRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteOrganizationMembershipRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteOrganizationMembershipRequest buildRequest() {
        DeleteOrganizationMembershipRequest request = new DeleteOrganizationMembershipRequest(this.organizationId, this.userId);
        return request;
    }

    public DeleteOrganizationMembershipResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteOrganizationMembership.Sync operation = new DeleteOrganizationMembership.Sync(this.sdkConfiguration, options);
        DeleteOrganizationMembershipRequest request = this.buildRequest();
        return (DeleteOrganizationMembershipResponse)operation.handleResponse(operation.doRequest(request));
    }
}

