/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteOrganizationRequest;
import com.clerk.backend_api.models.operations.DeleteOrganizationResponse;
import com.clerk.backend_api.operations.DeleteOrganization;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteOrganizationRequestBuilder {
    private String organizationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteOrganizationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteOrganizationRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public DeleteOrganizationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteOrganizationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteOrganizationRequest buildRequest() {
        DeleteOrganizationRequest request = new DeleteOrganizationRequest(this.organizationId);
        return request;
    }

    public DeleteOrganizationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteOrganization.Sync operation = new DeleteOrganization.Sync(this.sdkConfiguration, options);
        DeleteOrganizationRequest request = this.buildRequest();
        return (DeleteOrganizationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

