/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteRedirectURLRequest;
import com.clerk.backend_api.models.operations.DeleteRedirectURLResponse;
import com.clerk.backend_api.operations.DeleteRedirectURL;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteRedirectURLRequestBuilder {
    private String id;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteRedirectURLRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteRedirectURLRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public DeleteRedirectURLRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteRedirectURLRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteRedirectURLRequest buildRequest() {
        DeleteRedirectURLRequest request = new DeleteRedirectURLRequest(this.id);
        return request;
    }

    public DeleteRedirectURLResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteRedirectURL.Sync operation = new DeleteRedirectURL.Sync(this.sdkConfiguration, options);
        DeleteRedirectURLRequest request = this.buildRequest();
        return (DeleteRedirectURLResponse)operation.handleResponse(operation.doRequest(request));
    }
}

