/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteSAMLConnectionRequest;
import com.clerk.backend_api.models.operations.DeleteSAMLConnectionResponse;
import com.clerk.backend_api.operations.DeleteSAMLConnection;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteSAMLConnectionRequestBuilder {
    private String samlConnectionId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteSAMLConnectionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteSAMLConnectionRequestBuilder samlConnectionId(String samlConnectionId) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        this.samlConnectionId = samlConnectionId;
        return this;
    }

    public DeleteSAMLConnectionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteSAMLConnectionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteSAMLConnectionRequest buildRequest() {
        DeleteSAMLConnectionRequest request = new DeleteSAMLConnectionRequest(this.samlConnectionId);
        return request;
    }

    public DeleteSAMLConnectionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteSAMLConnection.Sync operation = new DeleteSAMLConnection.Sync(this.sdkConfiguration, options);
        DeleteSAMLConnectionRequest request = this.buildRequest();
        return (DeleteSAMLConnectionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

