/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteUserProfileImageRequest;
import com.clerk.backend_api.models.operations.DeleteUserProfileImageResponse;
import com.clerk.backend_api.operations.DeleteUserProfileImage;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteUserProfileImageRequestBuilder {
    private String userId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteUserProfileImageRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteUserProfileImageRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public DeleteUserProfileImageRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteUserProfileImageRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteUserProfileImageRequest buildRequest() {
        DeleteUserProfileImageRequest request = new DeleteUserProfileImageRequest(this.userId);
        return request;
    }

    public DeleteUserProfileImageResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteUserProfileImage.Sync operation = new DeleteUserProfileImage.Sync(this.sdkConfiguration, options);
        DeleteUserProfileImageRequest request = this.buildRequest();
        return (DeleteUserProfileImageResponse)operation.handleResponse(operation.doRequest(request));
    }
}

