/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.DeleteUserRequest;
import com.clerk.backend_api.models.operations.DeleteUserResponse;
import com.clerk.backend_api.operations.DeleteUser;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class DeleteUserRequestBuilder {
    private String userId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public DeleteUserRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DeleteUserRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public DeleteUserRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DeleteUserRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DeleteUserRequest buildRequest() {
        DeleteUserRequest request = new DeleteUserRequest(this.userId);
        return request;
    }

    public DeleteUserResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DeleteUser.Sync operation = new DeleteUser.Sync(this.sdkConfiguration, options);
        DeleteUserRequest request = this.buildRequest();
        return (DeleteUserResponse)operation.handleResponse(operation.doRequest(request));
    }
}

