/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class File {
    @SpeakeasyMetadata(value="multipartForm:name=fileName")
    private String fileName;
    @SpeakeasyMetadata(value="multipartForm:content")
    private byte[] content;

    @JsonCreator
    public File(String fileName, byte[] content) {
        Utils.checkNotNull(fileName, "fileName");
        Utils.checkNotNull(content, "content");
        this.fileName = fileName;
        this.content = content;
    }

    @JsonIgnore
    public String fileName() {
        return this.fileName;
    }

    @JsonIgnore
    public byte[] content() {
        return this.content;
    }

    public static Builder builder() {
        return new Builder();
    }

    public File withFileName(String fileName) {
        Utils.checkNotNull(fileName, "fileName");
        this.fileName = fileName;
        return this;
    }

    public File withContent(byte[] content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        File other = (File)o;
        return Utils.enhancedDeepEquals(this.fileName, other.fileName) && Utils.enhancedDeepEquals(this.content, other.content);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.fileName, this.content);
    }

    public String toString() {
        return Utils.toString(File.class, "fileName", this.fileName, "content", this.content);
    }

    public static final class Builder {
        private String fileName;
        private byte[] content;

        private Builder() {
        }

        public Builder fileName(String fileName) {
            Utils.checkNotNull(fileName, "fileName");
            this.fileName = fileName;
            return this;
        }

        public Builder content(byte[] content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        public File build() {
            return new File(this.fileName, this.content);
        }
    }
}

