/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.PayerType;
import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class GetCommercePlanListRequest {
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=paginated")
    private Optional<Boolean> paginated;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=payer_type")
    private Optional<? extends PayerType> payerType;

    @JsonCreator
    public GetCommercePlanListRequest(Optional<Boolean> paginated, Optional<Long> limit, Optional<Long> offset, Optional<? extends PayerType> payerType) {
        Utils.checkNotNull(paginated, "paginated");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        Utils.checkNotNull(payerType, "payerType");
        this.paginated = paginated;
        this.limit = limit;
        this.offset = offset;
        this.payerType = payerType;
    }

    public GetCommercePlanListRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Boolean> paginated() {
        return this.paginated;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    @JsonIgnore
    public Optional<PayerType> payerType() {
        return this.payerType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public GetCommercePlanListRequest withPaginated(boolean paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = Optional.ofNullable(paginated);
        return this;
    }

    public GetCommercePlanListRequest withPaginated(Optional<Boolean> paginated) {
        Utils.checkNotNull(paginated, "paginated");
        this.paginated = paginated;
        return this;
    }

    public GetCommercePlanListRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public GetCommercePlanListRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public GetCommercePlanListRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public GetCommercePlanListRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public GetCommercePlanListRequest withPayerType(PayerType payerType) {
        Utils.checkNotNull(payerType, "payerType");
        this.payerType = Optional.ofNullable(payerType);
        return this;
    }

    public GetCommercePlanListRequest withPayerType(Optional<? extends PayerType> payerType) {
        Utils.checkNotNull(payerType, "payerType");
        this.payerType = payerType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetCommercePlanListRequest other = (GetCommercePlanListRequest)o;
        return Utils.enhancedDeepEquals(this.paginated, other.paginated) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset) && Utils.enhancedDeepEquals(this.payerType, other.payerType);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.paginated, this.limit, this.offset, this.payerType);
    }

    public String toString() {
        return Utils.toString(GetCommercePlanListRequest.class, "paginated", this.paginated, "limit", this.limit, "offset", this.offset, "payerType", this.payerType);
    }

    public static final class Builder {
        private Optional<Boolean> paginated = Optional.empty();
        private Optional<Long> limit;
        private Optional<Long> offset;
        private Optional<? extends PayerType> payerType = Optional.empty();
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder paginated(boolean paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = Optional.ofNullable(paginated);
            return this;
        }

        public Builder paginated(Optional<Boolean> paginated) {
            Utils.checkNotNull(paginated, "paginated");
            this.paginated = paginated;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public Builder payerType(PayerType payerType) {
            Utils.checkNotNull(payerType, "payerType");
            this.payerType = Optional.ofNullable(payerType);
            return this;
        }

        public Builder payerType(Optional<? extends PayerType> payerType) {
            Utils.checkNotNull(payerType, "payerType");
            this.payerType = payerType;
            return this;
        }

        public GetCommercePlanListRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new GetCommercePlanListRequest(this.paginated, this.limit, this.offset, this.payerType);
        }
    }
}

